{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 19.10.98 - 14:13:10 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, MMObj, MMUtils, MMConect, MMDesign, MMDSPObj, MMWavIn, MMPeak,
  StdCtrls, MMDIBCv, MMSpectr, MMHook, MMSystem;
  
type
  TForm1 = class(TForm)
    MMPeakDetect1: TMMPeakDetect;
    MMWaveIn1: TMMWaveIn;
    MMDesigner1: TMMDesigner;
    MMSpectrum1: TMMSpectrum;
    MMConnector1: TMMConnector;
    Button1: TButton;
    Button2: TButton;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label14: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure MMConnector1Trigger(Sender: TObject);
  private
    MaxFreq: integer;
    MaxAmp : integer;
    Max1000: integer;
    MaxPeak: integer;
    PeakCnt: integer;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button2Click(Sender: TObject);
begin
   MaxFreq := 0;
   MaxAmp  := 0;
   Max1000 := 0;
   MaxPeak := 0;
   PeakCnt := 0;

   MMWaveIn1.Start;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   MMWaveIn1.Close;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   MMWaveIn1.Close;
end;

procedure TForm1.MMConnector1Trigger(Sender: TObject);
var
   i: integer;
   MaxVal,idx: integer;
begin
   inc(PeakCnt);
   if (PeakCnt mod 250 = 0) then
   begin
      MaxAmp  := 0;
      MaxFreq := 0;
      Max1000 := 0;
      MaxPeak := 0;
   end;

   with MMPeakDetect1 do
   begin
      // find the frequency with highest amplitude
      MaxVal := 0;
      idx    := 0;
      for i := 0 to NumPeaks-1 do
      begin
         if (Peaks[i] > MaxVal) then
         begin
            MaxVal := Peaks[i];
            idx := i;
         end;
      end;
      // sort it out
      if (MaxVal > MaxAmp) then
      begin
         MaxAmp := MaxVal;
         MaxFreq := idx;
      end;

      // find the amplitude at 1000 Hz
      MaxVal := Peaks[GetPeakIndex(1000)];
      if (MaxVal > Max1000) then
          Max1000 := MaxVal;

      // get the Total peak, we work with mono so we use the left channel only
      MaxVal := PeakLeft;
      if (MaxVal > MaxPeak) then
          MaxPeak := MaxVal;

      // Max Frequency
      Label1.Caption := Format('%2.2f Hz',[(MaxFreq+1)*Resolution]);
      // Max Amplitude
      Label2.Caption := VolumeToString(MaxAmp,32768,2);
      // Frequency Resolution
      Label3.Caption := Format('%2.2f Hz',[Resolution]);
      // show the amplitude at 1000 Hz, use GetPeakIndex to find the index
      Label4.Caption := VolumeToString(Max1000,32768,2);
      // show the total peak
      Label5.Caption := VolumeToString(MaxPeak,32768,2);
   end;
end;

end.
